<?php

namespace Zone;

use  Game\Config\ConfigBase;

class Zone_1 extends ConfigBase
{
    public function InitConfig()
    {
        $this->ServerId = 1;
        $this->ChannelId = 1;
        $this->RoleIdVersion = 1;
        $this->GameServiceId = 100010001;
        $this->NoticeServiceId = 400010001;
        $this->NoticeServerIp = '192.168.0.21';
        $this->NoticeServerPort = 8001;
        $this->OpenServerTime = '2023-5-25 08:00:00';
        $this->DataVersion = 1001; // 区号 * 1000 + 第几次更新
        $this->PlayerRedisNode = array(
            '127.0.0.1:1001',
            '127.0.0.1:1002',
            '127.0.0.1:1003',
        );
        $this->ServerRedisNode = array(
            '127.0.0.1:1001',
            '127.0.0.1:1002',
            '127.0.0.1:1003',
        );
        $this->FullServerRedisNode = array(
            '127.0.0.1:1001',
            '127.0.0.1:1002',
            '127.0.0.1:1003',
        );
        $this->MatchingRedisIp = '127.0.0.1';
        $this->MatchingRedisPort = 1000;
        $this->FullServerIp = '127.0.0.1';
        $this->FullServerPort = 1000;
        $this->ServiceServerIp = '192.168.0.21';
        $this->ServiceServerPort = 900;
        $this->LogPath = "webGame";
        $this->CLILogPath = "CLIGame";
        $this->ServiceLogPath = "Service";
        $this->ServiceSaveDataTimeout = 60;
        $this->CLIServerSleep = 1;
        $this->RankServerId = [
            1 => 1,
        ];
    }
}
