<?php

namespace Tool\MakeLocustRequestFile\Util;

use Tool\MakeLocustRequestFile\Config\Config;

class TxtUtil
{
//    public string $folderName;
//    private string $folderPath;

    public function checkFileExist($fileWithPatch): bool
    {
        return file_exists($fileWithPatch);
    }

    public function InitFolder()
    {
        if (!file_exists(Config::DATA_FOLDER_NAME)) {
            mkdir(Config::DATA_FOLDER_NAME);
        }
    }

    public function writeTxtFile(string $fileName, array $data)
    {
        $filePath = Config::DATA_FOLDER_NAME."/".$fileName.".txt";
        $file = fopen($filePath, "wb");
        if (false == $file) {
            echo "file open error! fileName:".$fileName;
            return;
        }
        foreach ($data as $datum) {
            fwrite($file, $datum);
        }
        fclose($file);
    }

    //脚本完成后,记录本次操作信息
    public function finishRecord()
    {
        $optionMsg = [sprintf("%s\t生成账号数量:%u\n包含模块:\n", date("Y-m-d H:i:s"), Config::ACCOUNT_NUM)];
        $mo = array_flip(Config::REQUEST_MODEL);
        foreach ($mo as $modelName => $v) {
            $optionMsg[] = $modelName . "\n";
        }
        $this->writeTxtFile(Config::READ_ME_FILE, $optionMsg);
    }
}
