<?php

/**
 * 注册账号 脚本启动时 检查目录并注册账号
 */

namespace Tool\MakeLocustRequestFile\Util;

use Tool\MakeLocustRequestFile\Config\Config;

class RegisterAccountUtil
{

    public function initAccountData()
    {
        $txtUtil = new TxtUtil();
        //创建数据文件夹
        $txtUtil->InitFolder();
        //检查账号文件是否存在
        if (!$txtUtil->checkFileExist(Config::ACCOUNT_FILE)) {
            $file = fopen(Config::ACCOUNT_FILE, 'w');
            fclose($file);
        }
        //读取账号文件,检查账号数量是否足够
        $accountData = file(Config::ACCOUNT_FILE);
        if (count($accountData) < Config::ACCOUNT_NUM) {
            $file = fopen(Config::ACCOUNT_FILE, 'a+');
            $idxStart = substr((string)time(), -6);
            //补充账号
            $accountLogin = new AccountLogin();
            $num = Config::ACCOUNT_NUM - count($accountData);
            for ($i = 0; $i < $num; $i++) {
                $account = Config::ACCOUNT_PREFIX.$idxStart. (string)$i;
                $playerData = $accountLogin->makeRegisterProcessData($account);
                if (empty($playerData)) {
                    print_r("create account error!,account:".$account."\n");
                    continue;
                }
                //存储账号,json
                $playerDataJson = json_encode($playerData);
                $str = $playerDataJson."\n";
                fwrite($file, $str);
            }
            fclose($file);
        }
    }
}
