<?php

/**
 * 注册玩家数据
 */

namespace Tool\MakeLocustRequestFile\Util;

use Library\Common\Singletons;

class PlayerData
{
    use Singletons;

    private int $playerId;
    private string $account;
    private int $defaultCarUid;
    private int $defaultCatId;

    public const KEY_PLAYER_ID = "playerId";
    public const KEY_ACCOUNT = "account";
    public const KEY_DEFAULT_CAR_UID = "CarUid";
    public const KEY_DEFAULT_CAR_ID = "CarId";


    public function clearPlayerData(array $data)
    {
        $this->playerId = $data[self::KEY_PLAYER_ID];
        $this->account = $data[self::KEY_ACCOUNT];
        $this->defaultCarUid = $data[self::KEY_DEFAULT_CAR_UID];
        $this->defaultCatId = $data[self::KEY_DEFAULT_CAR_ID];
    }

    /**
     * @return int
     */
    public function getPlayerId(): int
    {
        return $this->playerId;
    }

    /**
     * @return string
     */
    public function getAccount(): string
    {
        return $this->account;
    }

    /**
     * @return int
     */
    public function getDefaultCarUid(): int
    {
        return $this->defaultCarUid;
    }

    /**
     * @return int
     */
    public function getDefaultCatId(): int
    {
        return $this->defaultCatId;
    }
}
