<?php

namespace Tool\MakeLocustRequestFile\Util;

use Library\Common\Singletons;
use Framework\Protobuf\SinglePacket;
use Framework\Protobuf\WebRequestMessage;
use Tool\MakeLocustRequestFile\Config\Config;
use Google\Protobuf\Internal\Message;

class PacketUtil
{
    use Singletons;

    private int $index = 0;

    public function getRequestPacket(Message $packet, int $packetId): string
    {
        $packetStr = base64_encode($packet->serializeToString());
        $single_packet = new SinglePacket();
        $single_packet->setId($packetId);
        $single_packet->setData($packetStr);
        $this->index++;
        $message = new WebRequestMessage();
        $message->setIndex($this->index);
        $message->setServerId(Config::SERVER_ID);
        $message->setSession(PlayerData::getInstance()->getPlayerId());
        $message->setPlayerId(PlayerData::getInstance()->getPlayerId());
        $message->setPacketList([$single_packet]);
        return base64_encode($message->serializeToString())."\n";
    }

    public function resetIndex()
    {
        $this->index = 0;
    }
}
