<?php

/**
 * 生成登录数据
 */

namespace Tool\MakeLocustRequestFile\Util;

use Framework\Protobuf\SinglePacket;
use Framework\Protobuf\WebRequestMessage;
use Framework\Protobuf\WebRespondMessage;
use Game\Constant\ClientErrorCode;
use Game\Protobuf\CarDataSingle;
use Game\Protobuf\CGCreateAccount;
use Game\Protobuf\CGInputName;
use Game\Protobuf\CGLoginCheckMsg;
use Game\Protobuf\CGSaveGuideStep;
use Game\Protobuf\CGSelectCar;
use Game\Protobuf\GCCreateAccount;
use Game\Protobuf\GCUpdateCarRecv;
use Game\Protobuf\PacketId;
use Game\Protobuf\UserLoginRecv;
use Game\Protobuf\UserLoginSend;
use Tool\MakeLocustRequestFile\Config\Config;
use Tool\MakeLocustRequestFile\Config\Constant;

class AccountLogin
{
    private HttpUtil $httpUtil;

    private int $index;
    private int $playerId;

    public function init()
    {
        $this->index = 0;
        $this->playerId = 0;
    }

    private function indexAdd()
    {
        $this->index++;
    }

    public function initHttp()
    {
        $this->httpUtil = new HttpUtil();
    }

    // 准备账号信息 完成注册流程

    //注册流程顺序
    public function makeRegisterProcessData(string $account): array
    {
        $playerData = array();
        $this->init();
        $this->initHttp();
        $playerId = $this->registerAccount($account);
        if ($playerId == 0) {
            return $playerData;
        }
        $this->playerId = $playerId;
        $this->indexAdd();
        //选择模型
        $this->selectMod();
        $this->indexAdd();
        //输入昵称
        if (!$this->inputNickname($account)) {
            return $playerData;
        }
        $this->indexAdd();
        //选车
        $carUid = $this->createRoleCar();
        if ($carUid == 0) {
            return $playerData;
        }
        $this->indexAdd();
        //注册完成
        $this->reigiseterOver();
        $this->indexAdd();
        //登录检测
        $this->delayLoginCheck();
        $this->indexAdd();
        //返回数据
        $playerData[PlayerData::KEY_PLAYER_ID] = $playerId;
        $playerData[PlayerData::KEY_ACCOUNT] = $account;
        $playerData[PlayerData::KEY_DEFAULT_CAR_UID] = $carUid;
        $playerData[PlayerData::KEY_DEFAULT_CAR_ID] = Config::CREATE_DEFAULT_CAR_ID;
        return $playerData;
    }

    //注册获得playerId
    public function registerAccount(string $account): int
    {
        $playerId = 0;
        $response = $this->httpUtil->httpPost(
            $this->getLoginData($account, $playerId)
        );
        $resp = new WebRespondMessage();
        $resp->mergeFromString($response);
//        echo $resp->getIndex();
        foreach ($resp->getPacketList() as $packet) {
            /**
             * @var SinglePacket $packet
             */
            if ($packet->getId() == PacketId::User_Login_Recv) {
                $loginRespStr = base64_decode($packet->getData());
                $loginRecv = new UserLoginRecv();
                $loginRecv->mergeFromString($loginRespStr);
                $playerId = $loginRecv->getUserId();
            }
        }
        return $playerId;
    }

    //打包登录数据
    private function getLoginData(string $account, int $playerId): string
    {
        $packet = new UserLoginSend();
        $packet->setAccountType(Constant::ACCOUNT_TYPE);
        $packet->setAccount($account);
        $packet->setClientData(json_encode(Constant::CLIENT_DATA));
        $packetStr = base64_encode($packet->serializeToString());
        $single_packet = new SinglePacket();
        $single_packet->setId(PacketId::User_Login_Send);
        $single_packet->setData($packetStr);
        $message = new WebRequestMessage();
        $message->setIndex($this->index);
        $message->setServerId(Config::SERVER_ID);
        $message->setSession("");
        $message->setPlayerId($playerId);
        $message->setPacketList([$single_packet]);
        return $message->serializeToString();
    }

    //选择模型
    private function selectMod()
    {
        $response = $this->httpUtil->httpPost(
            $this->getSelectModData()
        );
    }

    private function getSelectModData(): string
    {
        $packet = new CGCreateAccount();
        $packet->setStep(Constant::STEP_SELECT_MOD);
        $packet->setModelID(Config::ROLE_MOD_ID);
        $packetStr = base64_encode($packet->serializeToString());
        $single_packet = new SinglePacket();
        $single_packet->setId(PacketId::CG_CreateAccount);
        $single_packet->setData($packetStr);
        $message = new WebRequestMessage();
        $message->setIndex($this->index);
        $message->setServerId(Config::SERVER_ID);
        $message->setSession("");
        $message->setPlayerId($this->playerId);
        $message->setPacketList([$single_packet]);
        return $message->serializeToString();
    }

    //输入昵称
    private function inputNickname(string $account): bool
    {
        $response = $this->httpUtil->httpPost(
            $this->getInputNicknameData($account)
        );
        $resp = new WebRespondMessage();
        $resp->mergeFromString($response);
        foreach ($resp->getPacketList() as $packet) {
            /**
             * @var SinglePacket $packet
             */
            if ($packet->getId() == PacketId::GC_CreateAccount) {
                $loginRespStr = base64_decode($packet->getData());
                $loginRecv = new GCCreateAccount();
                $loginRecv->mergeFromString($loginRespStr);
                return $loginRecv->getCode() == ClientErrorCode::CLIENT_SUCCESS;
            }
        }
        return false;
    }

    //输入昵称请求数据
    private function getInputNicknameData(string $account): string
    {
        $packet = new CGInputName();
        $packet->setStep(Constant::STEP_INPUT_NICKNAME);
        $packet->setNickName($account);
        $packetStr = base64_encode($packet->serializeToString());
        $single_packet = new SinglePacket();
        $single_packet->setId(PacketId::CG_InputName);
        $single_packet->setData($packetStr);
        $message = new WebRequestMessage();
        $message->setIndex($this->index);
        $message->setServerId(Config::SERVER_ID);
        $message->setSession("");
        $message->setPlayerId($this->playerId);
        $message->setPacketList([$single_packet]);
        return $message->serializeToString();
    }

    //选择默认车
    private function createRoleCar(): int
    {
        $response = $this->httpUtil->httpPost(
            $this->getCreateRoleCarData()
        );
        $resp = new WebRespondMessage();
        $resp->mergeFromString($response);
        foreach ($resp->getPacketList() as $packet) {
            /**
             * @var SinglePacket $packet
             */
            if ($packet->getId() == PacketId::GC_Car_Update_Recv) {
                $respStr = base64_decode($packet->getData());
                $recv = new GCUpdateCarRecv();
                $recv->mergeFromString($respStr);
                foreach ($recv->getCar() as $carData) {
                    /**
                     * @var CarDataSingle $carData
                     */
                    if ($carData->getCarID() == Config::CREATE_DEFAULT_CAR_ID) {
                        return $carData->getUid();
                    }
                }
            }
        }
        return 0;
    }

    private function getCreateRoleCarData(): string
    {
        $packet = new CGSelectCar();
        $packet->setStep(Constant::STEP_SELECT_CAR);
        $packet->setCarTplID(Config::CREATE_DEFAULT_CAR_ID);
        $packet->setItemID(Config::CREATE_DEFAULT_CAR_ITEM_ID);
        $packetStr = base64_encode($packet->serializeToString());
        $single_packet = new SinglePacket();
        $single_packet->setId(PacketId::CG_SelectCar);
        $single_packet->setData($packetStr);
        $message = new WebRequestMessage();
        $message->setIndex($this->index);
        $message->setServerId(Config::SERVER_ID);
        $message->setSession("");
        $message->setPlayerId($this->playerId);
        $message->setPacketList([$single_packet]);
        return $message->serializeToString();
    }

    //注册完成
    private function reigiseterOver()
    {
        $response = $this->httpUtil->httpPost(
            $this->getRegisterOverData()
        );
    }

    private function getRegisterOverData(): string
    {
        $packet = new CGSaveGuideStep();
        $packet->setStep(Constant::STEP_OVER);
        $packetStr = base64_encode($packet->serializeToString());
        $single_packet = new SinglePacket();
        $single_packet->setId(PacketId::CG_SaveGuideStep);
        $single_packet->setData($packetStr);
        $message = new WebRequestMessage();
        $message->setIndex($this->index);
        $message->setServerId(Config::SERVER_ID);
        $message->setSession("");
        $message->setPlayerId($this->playerId);
        $message->setPacketList([$single_packet]);
        return $message->serializeToString();
    }

    //登录检测
    private function delayLoginCheck()
    {
        $response = $this->httpUtil->httpPost(
            $this->getDelayLoginCheckData()
        );
    }

    private function getDelayLoginCheckData()
    {
        $packet = new CGLoginCheckMsg();
        $packetStr = base64_encode($packet->serializeToString());
        $single_packet = new SinglePacket();
        $single_packet->setId(PacketId::CG_LoginCheckMsg);
        $single_packet->setData($packetStr);
        $message = new WebRequestMessage();
        $message->setIndex($this->index);
        $message->setServerId(Config::SERVER_ID);
        $message->setSession("");
        $message->setPlayerId($this->playerId);
        $message->setPacketList([$single_packet]);
        return $message->serializeToString();
    }
}
