<?php

/**
 * 生成测试登录账号
 */

namespace Tool\MakeLocustRequestFile\Script;

require_once __DIR__ . '/../../../Library/AutoLoad.php';

use Framework\Protobuf\SinglePacket;
use Framework\Protobuf\WebRequestMessage;
use Game\Protobuf\CGTestLogin;
use Game\Protobuf\PacketId;
use Tool\MakeLocustRequestFile\Config\Config;
use Tool\MakeLocustRequestFile\Config\Constant;
use Tool\MakeLocustRequestFile\Util\TxtUtil;

class MakeTestLoginData
{

    //生成测试注册账号
    public function makeTestLoginData(int $idx)
    {
        $account = Config::ACCOUNT_PREFIX.$idx;
        $data[] = $this->getTestLoginData($account);
        $txtUtil = new TxtUtil();
        $txtUtil->writeTxtFile($idx, $data);
    }

    private function getTestLoginData(string $account):string
    {
        $packet = new CGTestLogin();
        $packet->setAccountType(Constant::ACCOUNT_TYPE);
        $packet->setAccount($account);
        $packet->setClientData(json_encode(Constant::CLIENT_DATA));
        $packet->setNickName($account);
        $packet->setModelID(Config::ROLE_MOD_ID);
        $packet->setCarTplID(Config::CREATE_DEFAULT_CAR_ID);
        $packet->setItemID(Config::CREATE_DEFAULT_CAR_ITEM_ID);
        $packetStr = base64_encode($packet->serializeToString());
        $single_packet = new SinglePacket();
        $single_packet->setId(PacketId::CG_TestLogin);
        $single_packet->setData($packetStr);
        $message = new WebRequestMessage();
        $message->setIndex(0);
        $message->setServerId(Config::SERVER_ID);
        $message->setSession("");
        $message->setPlayerId(0);
        $message->setPacketList([$single_packet]);
//        return $message->serializeToString();
        return base64_encode($message->serializeToString())."\n";
    }
}

//测试
//$make = new MakeTestLoginData();
//$make->makeTestLoginData(1);

