<?php

/**
 * 任务
 */

namespace Tool\MakeLocustRequestFile\Model;

use Game\Constant\ConstTemplate\TemplateTask;
use Game\Protobuf\CGDailyInfo;
use Game\Protobuf\CGDailyTaskOption;
use Game\Protobuf\CGTaskSearch;
use Game\Protobuf\PacketId;
use Tool\MakeLocustRequestFile\Util\PacketUtil;

class Task extends BaseModel
{
    private const DAILY_TASK_OPTION_SUBMIT = 1; //日常提交任务
    private const DAILY_TASK_OPTION_GET_REWARD = 2; //日常领取活跃度奖励

    public function getRequestData(array &$data)
    {
        $data[] = $this->getDailyTaskData();
        $data[] = $this->getDailyInfoData();
        $data[] = $this->getDailyTaskOptionData(self::DAILY_TASK_OPTION_SUBMIT);
        $data[] = $this->getDailyTaskOptionData(self::DAILY_TASK_OPTION_GET_REWARD);
    }

    //获取日常任务
    private function getDailyTaskData(): string
    {
        $packet = new CGTaskSearch();
        $packet->setType(TemplateTask::TASK_TYPE_DAILY);
        return PacketUtil::getInstance()->getRequestPacket(
            $packet,
            PacketId::CG_TaskSearch
        );
    }

    //获取日常信息
    private function getDailyInfoData(): string
    {
        $packet = new CGDailyInfo();
        return PacketUtil::getInstance()->getRequestPacket(
            $packet,
            PacketId::CG_DailyInfo
        );
    }

    //日常任务操作
    private function getDailyTaskOptionData(int $option): string
    {
        $packet = new CGDailyTaskOption();
        $packet->setOption($option);
        return PacketUtil::getInstance()->getRequestPacket(
            $packet,
            PacketId::CG_DailyTaskOption
        );
    }
}
