<?php

/**
 * 邮件相关
 */

namespace Tool\MakeLocustRequestFile\Model;

use Game\Protobuf\CGMailOption;
use Game\Protobuf\CGMailSearch;
use Game\Protobuf\PacketId;
use Tool\MakeLocustRequestFile\Util\PacketUtil;

class Mail extends BaseModel
{
    private const OPTION_ALL_DELETE_ALREADY_READ = 4;    //一键删除已读邮件
    private const OPTION_ALL_GET_ENCLOSURE = 5;          //一键领取附件

    public function getRequestData(array &$data)
    {
        $data[] = $this->getAllMailData(0, 20);
        $data[] = $this->mailOptionData(self::OPTION_ALL_GET_ENCLOSURE);
        $data[] = $this->mailOptionData(self::OPTION_ALL_DELETE_ALREADY_READ);
    }

    //获取邮件
    private function getAllMailData(int $start, int $end): string
    {
        $packet = new CGMailSearch();
        $packet->setStart($start);
        $packet->setEnd($end);
        return PacketUtil::getInstance()->getRequestPacket(
            $packet,
            PacketId::CG_MailSearch
        );
    }

    //邮件操作--一键操作
    private function mailOptionData(int $option): string
    {
        $packet = new CGMailOption();
        $packet->setOption($option);
        return PacketUtil::getInstance()->getRequestPacket(
            $packet,
            PacketId::CG_MailOption
        );
    }
}
