<?php

/**
 * 登录和角色相关请求数据
 */

namespace Tool\MakeLocustRequestFile\Model;

use Game\Protobuf\CGCreateAccount;
use Game\Protobuf\CGInputName;
use Game\Protobuf\CGLoginCheckMsg;
use Game\Protobuf\CGSaveGuideStep;
use Game\Protobuf\CGSelectCar;
use Game\Protobuf\MD5VerifySend;
use Game\Protobuf\ModuleVerifyData;
use Game\Protobuf\PacketId;
use Game\Protobuf\UserLoginSend;
use Tool\MakeLocustRequestFile\Config\Config;
use Tool\MakeLocustRequestFile\Config\Constant;
use Tool\MakeLocustRequestFile\Util\PacketUtil;
use Tool\MakeLocustRequestFile\Util\PlayerData;

class Login extends BaseModel
{
    //获取请求数据
    public function getRequestData(array &$data)
    {
    }

    //获取注册顺序数据
    public function getRegisetProcessData(array &$data)
    {
        PacketUtil::getInstance()->resetIndex();
        $data[] = $this->getLoginData();
        $data[] = $this->getCreateRoleModData();
        $data[] = $this->getInputNicknameData();
        $data[] = $this->getCreateRoleCarData();
        $data[] = $this->getCreateOverData();
        $data[] = $this->getDelayLoginData();
    }

    //获取注册数据 排除Login请求,按注册顺序
    public function getRegisterData(array &$data)
    {
        PacketUtil::getInstance()->resetIndex();
        $data[] = $this->getCreateRoleModData();
        $data[] = $this->getInputNicknameData();
        $data[] = $this->getCreateRoleCarData();
        $data[] = $this->getCreateOverData();
        $data[] = $this->getDelayLoginData();
    }

    //账号登录
    public function getLoginData(): string
    {
        $packet = new UserLoginSend();
        $packet->setAccountType(Constant::ACCOUNT_TYPE);
        $packet->setAccount(PlayerData::getInstance()->getAccount());
        $packet->setClientData(json_encode(Constant::CLIENT_DATA));
        return PacketUtil::getInstance()->getRequestPacket(
            $packet,
            PacketId::User_Login_Send
        );
    }

    //模块数据校验
    public function getVerifyData(): string
    {
        $modulePacketList = array();
        foreach (Config::VERIFY_MODULE_LIST as $moduleId) {
            $module = new ModuleVerifyData();
            $module->setMoudleId($moduleId);
            $module->setMD5("123");
            $modulePacketList[] = $module;
        }
        $packet = new MD5VerifySend();
        $packet->setPacketList($modulePacketList);
        return PacketUtil::getInstance()->getRequestPacket(
            $packet,
            PacketId::Verify_Send
        );
    }

    //选择模型
    public function getCreateRoleModData(): string
    {
        $packet = new CGCreateAccount();
        $packet->setStep(Constant::STEP_SELECT_MOD);
        $packet->setModelID(Config::ROLE_MOD_ID);
        return PacketUtil::getInstance()->getRequestPacket(
            $packet,
            PacketId::CG_CreateAccount
        );
    }

    //输入昵称
    public function getInputNicknameData(): string
    {
        $packet = new CGInputName();
        $packet->setStep(Constant::STEP_INPUT_NICKNAME);
        $packet->setNickName(PlayerData::getInstance()->getAccount());
        return PacketUtil::getInstance()->getRequestPacket(
            $packet,
            PacketId::CG_InputName
        );
    }

    //创建默认车辆
    public function getCreateRoleCarData(): string
    {
        $packet = new CGSelectCar();
        $packet->setStep(Constant::STEP_SELECT_CAR);
        $packet->setCarTplID(Config::CREATE_DEFAULT_CAR_ID);
        $packet->setItemID(Config::CREATE_DEFAULT_CAR_ITEM_ID);
        return PacketUtil::getInstance()->getRequestPacket(
            $packet,
            PacketId::CG_SelectCar
        );
    }

    //创建结束
    public function getCreateOverData(): string
    {
        $packet = new CGSaveGuideStep();
        $packet->setStep(Constant::STEP_OVER);
        return PacketUtil::getInstance()->getRequestPacket(
            $packet,
            PacketId::CG_SaveGuideStep
        );
    }

    //登录之后检测
    public function getDelayLoginData(): string
    {
        $packet = new CGLoginCheckMsg();
        return PacketUtil::getInstance()->getRequestPacket(
            $packet,
            PacketId::CG_LoginCheckMsg
        );
    }
}
