<?php

/**
 * 生成注册数据,第一步先注册账号获得playerId
 * 然后根据需要,完成注册流程
 */

namespace Tool\MakeLocustRequestFile;

require_once __DIR__ . '/../../Library/AutoLoad.php';

use Tool\MakeLocustRequestFile\Config\Config;
use Tool\MakeLocustRequestFile\Model\Login;
use Tool\MakeLocustRequestFile\Util\AccountLogin;
use Tool\MakeLocustRequestFile\Util\PlayerData;
use Tool\MakeLocustRequestFile\Util\TxtUtil;

function run() {
    $idxStart = substr((string)time(), -6);
    $config = new Config();
    $model = $config->getModelName(Config::MODEL_LOGIN);
    /**
     * @var Login $login
     */
    $login = new $model();
    $txtUtil = new TxtUtil();
    $txtUtil->InitFolder();

    $accountLogin = new AccountLogin();
    $accountLogin->initHttp();

    $playerData = array();
    $playerData[PlayerData::KEY_PLAYER_ID] = 0;
    $playerData[PlayerData::KEY_DEFAULT_CAR_UID] = 0;
    $playerData[PlayerData::KEY_DEFAULT_CAR_ID] = Config::CREATE_DEFAULT_CAR_ID;

    for ($i = 0; $i < Config::ACCOUNT_NUM; $i++) {
        $data = array();
        $account = Config::ACCOUNT_PREFIX.$idxStart. (string)$i;
        $playerData[PlayerData::KEY_ACCOUNT] = $account;
        PlayerData::getInstance()->clearPlayerData($playerData);
        $accountLogin->init();
        //登录
        $playerId = $accountLogin->registerAccount($account);
        if ($playerId == 0) {
            print_r("create account error!,account:".$account."\n");
            continue;
        }
        $playerData[PlayerData::KEY_PLAYER_ID] = $playerId;
        $loginData = $login->getLoginData();
        $data[] = $loginData;
        //注册流程
        $login->getRegisterData($data);
        //写入数据
        $txtUtil->writeTxtFile($playerId, $data);
    }
}

run();
