<?php

/**
 * 只生成登录数据
 */

namespace Tool\MakeLocustRequestFile;

require_once __DIR__ . '/../../Library/AutoLoad.php';

use Tool\MakeLocustRequestFile\Config\Config;
use Tool\MakeLocustRequestFile\Model\Login;
use Tool\MakeLocustRequestFile\Util\PlayerData;
use Tool\MakeLocustRequestFile\Util\TxtUtil;

function run() {
    $idxStart = substr((string)time(), -6);
    $config = new Config();
    $model = $config->getModelName(Config::MODEL_LOGIN);
    /**
     * @var Login $login
     */
    $login = new $model();
    $txtUtil = new TxtUtil();
    $txtUtil->InitFolder();

    $playerData = array();
    $playerData[PlayerData::KEY_PLAYER_ID] = 0;
    $playerData[PlayerData::KEY_DEFAULT_CAR_UID] = 0;
    $playerData[PlayerData::KEY_DEFAULT_CAR_ID] = Config::CREATE_DEFAULT_CAR_ID;

    for ($i = 0; $i < Config::ACCOUNT_NUM; $i++) {
        $account = Config::ACCOUNT_PREFIX.$idxStart. (string)$i;
        $playerData[PlayerData::KEY_ACCOUNT] = $account;
        PlayerData::getInstance()->clearPlayerData($playerData);

        $loginData = $login->getLoginData();
        $txtUtil->writeTxtFile($idxStart. (string)$i, [$loginData]);
    }
}

run();
