<?php

namespace Tool\MakeLocustRequestFile;

require_once __DIR__ . '/../../Library/AutoLoad.php';

use Tool\MakeLocustRequestFile\Config\Config;
use Tool\MakeLocustRequestFile\Util\PlayerData;
use Tool\MakeLocustRequestFile\Util\RegisterAccountUtil;
use Tool\MakeLocustRequestFile\Util\TxtUtil;


function run()
{
    echo "Start Init Account\n";
    //初始账号
    $registerAccount = new RegisterAccountUtil();
    $registerAccount->initAccountData();

    $txtUtil = new TxtUtil();
    //根据需求 生成请求内容 存入文件
    $accountData = file(Config::ACCOUNT_FILE);
    echo "Start Create Request Data,Please Wait...\n<br>";
    $config = new Config();
    for ($i = 0; $i < Config::ACCOUNT_NUM; $i++) {
        $data = array();
        PlayerData::getInstance()->clearPlayerData(json_decode($accountData[$i], true));
        foreach (Config::REQUEST_MODEL as $modelName) {
            $modelPatch = $config->getModelName($modelName);
            if ($modelPatch == "") {
                echo "Not Found Model:".$modelName;
                continue;
            }
            $model = new $modelPatch();
            $model->getRequestData($data);
        }
        //存入文件
        $txtUtil->writeTxtFile(PlayerData::getInstance()->getPlayerId(), $data);
    }
    $txtUtil->finishRecord();
    echo "Create Request Data Finish\n";
}

run();
