<?php

namespace Tool\MakeLocustRequestFile\Config;

use Tool\MakeLocustRequestFile\Model\Login;
use Tool\MakeLocustRequestFile\Model\HeartBeat;
use Tool\MakeLocustRequestFile\Model\Mail;
use Tool\MakeLocustRequestFile\Model\Task;

class Config
{
    public const ACCOUNT_NUM = 1;   //生成账号数量

    public const GAME_URL = "http://192.168.0.10/test/GameIndex.php?zone=Zone_test";
//    public const GAME_URL = "http://zone3.ng.com/GameServer/GameIndex.php?zone=Zone_4";
    public const SERVER_ID = 1;

    public const ROLE_MOD_ID = 4;   //角色模型
    public const CREATE_DEFAULT_CAR_ID = 1004;  //创建账号默认车id
    public const CREATE_DEFAULT_CAR_ITEM_ID = 400004;   //默认车对应的ItemId
    public const VERIFY_MODULE_LIST = [1, 2, 3, 4, 8];  //校验模块id


    public const ACCOUNT_PREFIX = "Lo";     //账号前缀
    public const DATA_FOLDER_NAME = "Data";
    public const ACCOUNT_FILE = "Account.txt";  //账号文件
    public const READ_ME_FILE = "_ReadMe";      //操作记录

    //需要发送的请求模块 可重复 按需要测试模块添加请求
    public const REQUEST_MODEL = array(
        self::MODEL_LOGIN,
//        self::MODEL_HEART_BEAT,
//        self::MODEL_HEART_BEAT,
//        self::MODEL_MAIL,
//        self::MODEL_CAR,
    );

    public const MODEL_LOGIN = "Login";
    public const MODEL_HEART_BEAT = "HeartBeat";
    public const MODEL_MAIL = "Mail";
    public const MODEL_TASK = "Task";

    public const MODEL_MAP = array(
        self::MODEL_LOGIN => Login::class,
        self::MODEL_HEART_BEAT => HeartBeat::class,
        self::MODEL_MAIL => Mail::class,
        self::MODEL_TASK => Task::class,
    );

    public function getModelName(string $model): string
    {
        if (!array_key_exists($model, self::MODEL_MAP)) {
            return "";
        }
        return self::MODEL_MAP[$model];
    }
}
