<?php

/**
 * 处理txt文件 常用工具
 */

namespace Tool\LoadTemplate;

use DateTime;
use Exception;

class Util
{
    public const ID = "id";
    public const NUM = "num";
    public const RATE = "rate";
    /***
     * 分割 112*1;113*1 格式的字符串 返回array(112=>1,..id=>num)格式
     * @param string $str
     * @return array
     */
    public static function getFormatArray(string $str): array
    {
        $data = array();
        if ($str == "None") {
            return $data;
        }
        $tmp = explode(";", $str);
        foreach ($tmp as $str1) {
            $tmp2 = explode("*", $str1);
            $key = intval($tmp2[0]);
            $val = intval($tmp2[1]);
            isset($data[$key]) ? $data[$key] += $val : $data[$key] = $val;
        }
        return $data;
    }

    /***
     *
     return ↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓
     $items = [
    ['id' => 500003, 'num' => 1, 'rate' => 50],
    ['num' => 500004, 'num' => 1, 'rate' => 50],
    ];
     *
     * 分割 200001*1*50;200002*10*40;200003*1*10
     * @param string $str
     * @return array
     */
    public static function getStr3FormatArray(string $str): array
    {
        $data = array();
        if ($str == "None") {
            return $data;
        }
        $tmp = explode(";", $str);
        foreach ($tmp as $str1) {
            $tmp2 = explode("*", $str1);
            $id = (int)$tmp2[0];
            $num = (int)$tmp2[1];
            $rate = (int)$tmp2[2];
            $data[] = [
                self::ID => $id,
                self::NUM => $num,
                self::RATE => $rate,
            ];
        }
        return $data;
    }

    /***
     * 分割 112*1 格式的字符串 返回array(112,1,..id)格式
     * @param string $str
     * @return array
     */
    public static function getFormatArray3(string $str): array
    {
        $data = array();
        if ($str == "None") {
            return $data;
        }
        return explode(";", $str);
    }

    /**
     * 处理分号切割的字符串 输出为数组
     * @param string $str
     * @return array
     */
    public static function getFormatArrayToSemicolon(string $str): array {
        $data = array();
        if ($str == 'None') {
            return $data;
        }
        $tmp = explode(';', $str);
        foreach ($tmp as $v) {
            $data[] = (int)$v;
        }
        return $data;
    }

    /***
     * 分割 112*1;113*1 格式的字符串 返回array(112=>1,..id=>num)格式
     * 相同的道具id不合并
     * @param string $str
     * @return array
     */
    public static function getFormatArray4(string $str): array
    {
        $data = array();
        if ($str == "None" || $str == "0") {
            return $data;
        }
        $tmp = explode(";", $str);
        foreach ($tmp as $i => $str1) {
            $tmp2 = explode("*", $str1);
            $key = intval($tmp2[0]);
            $val = intval($tmp2[1]);
            $data[$i] = array($key => $val);
        }
        return $data;
    }

    // 处理任务条件
    public static function getFormatArray5(string $str): array
    {
        $data = array();
        if ($str == "None" || $str == "0") {
            return $data;
        }
        $tmp = explode(";", $str);
        foreach ($tmp as $i => $str1) {
            $tmp = explode("*", $str1);
            $tmp1 = array();
            foreach ($tmp as $val) {
                if (is_numeric($val)) {
                    $tmp1[] = (int)$val;
                } else {
                    $tmp1[] = $val;
                }
            }
            $data[$i] = $tmp1;
        }
        return $data;
    }

    //字符串时间转时间戳
    public static function StringToTime($val, &$ret): bool
    {
        try {
            $date = new DateTime ($val);
        } catch (Exception $e) {
            return false;
        }
        $ret = $date->getTimestamp();
        return true;
    }
}