<?php

/**
 * 整理战令商城道具,把相同赛季的道具id添加到赛季时间表
 */

namespace Tool\LoadTemplate\Tidy;

use Framework\Logic\TemplateHelp;
use Game\Constant\ConstTemplate\TemplateBPStore;
use Game\Constant\ConstTemplate\TemplateMatchTime;
use Game\Constant\TemplateDefine;
use Tool\LoadTemplate\ITidy;

class ZLStoreTidy extends ITidy
{
    use TemplateHelp;

    private array $ShopZLItemIds = array();       //赛季id=>[id,..]
    private array $ShopZLItemWeekResetIds = array();  //赛季id=>[id,..]
    private array $ShopZLItemForeverIds = array();    //赛季id=>[id,..]
    private array $ShopZLItemDailyResetIds = array();

    public function initTplInfo()
    {
        $this->newTemplateType = TemplateDefine::TYPE_MATCH_TIME;
    }

    public function allTidy($tplIdList): bool
    {
        //整理赛季商店道具
        foreach ($tplIdList as $id => $data) {
            foreach ($data[TemplateBPStore::SeasonId] as $seasonId) {
                $this->ShopZLItemIds[$seasonId][] = $id;
                switch ($data[TemplateBPStore::Term]) {
                    case TemplateBPStore::TERM_TYPE_WEEK:
                        //每周限购
                        $this->ShopZLItemWeekResetIds[$seasonId][] = $id;
                        break;
                    case TemplateBPStore::TERM_TYPE_FOREVER:
                        //永久
                        $this->ShopZLItemForeverIds[$seasonId][] = $id;
                        break;
                    case TemplateBPStore::TERM_TYPE_DAILY:
                        //每日限购
                        $this->ShopZLItemDailyResetIds[$seasonId][] = $id;
                        break;
                }
            }
        }
        $seasonTimeConfig = $this->getTable(TemplateDefine::TYPE_MATCH_TIME);
        foreach ($seasonTimeConfig as $seasonId => $data) {
            $data[TemplateMatchTime::ShopZLItemIds] = $this->ShopZLItemIds[$seasonId] ?? array();
            $data[TemplateMatchTime::ShopZLItemWeekResetIds] = $this->ShopZLItemWeekResetIds[$seasonId] ?? array();
            $data[TemplateMatchTime::ShopZLItemForeverIds] = $this->ShopZLItemForeverIds[$seasonId] ?? array();
            $data[TemplateMatchTime::ShopZLItemDailyResetIds] = $this->ShopZLItemDailyResetIds[$seasonId] ?? array();
            $this->addDBRowArray($seasonId, $data);
        }
        return true;
    }
}
