<?php
/**
 * 整理任务表,找出需要的id
 * 日常 [id,..]
 * 主线 id
 * 支线 CarId=>lv=>[id,..]
 * 战令周任务 周=>[id,..]
 * 战令高级任务 周=0 =>[id,..]
 */

namespace Tool\LoadTemplate\Tidy;

use Game\Constant\ConstTemplate\TemplateInitPlayer;
use Game\Constant\ConstTemplate\TemplateTask;
use Game\Constant\TemplateDefine;
use Tool\LoadTemplate\ITidy;

class TaskTidy extends ITidy
{
    private array $dailyTaskList = array();
    private array $welfareWeekTaskList = array();
    private int $mainTaskId = 0;
    private array $branchTaskList = array();
    private array $branchMainTaskList = array();    //支线任务主任务
    private array $seasonWeekTaskList = array();
    private array $seasonTaskList = array();
    private array $dailyChallengeTaskList = array();    //日常挑战任务
    private array $friendIntimacyTaskList = array();

    public function initTplInfo()
    {
        $this->newTemplateType = TemplateDefine::TYPE_INIT_PLAYER;
    }

    public function singleRowDeal($tpl): bool
    {
        //根据任务类型分类
        if ($tpl[TemplateTask::TaskType] == TemplateTask::TASK_TYPE_DAILY) {
            $this->dailyTaskList[] = $tpl[TemplateTask::Id];
            return true;
        }
        if ($tpl[TemplateTask::TaskType] == TemplateTask::TASK_TYPE_BRANCH) {
            //CarId=>lv=>array(id,..)
            $this->branchTaskList[$tpl[TemplateTask::GroupType]][$tpl[TemplateTask::GroupId]][] = $tpl[TemplateTask::Id];
            //检查是否为支线主任务
            if ($tpl[TemplateTask::ConditionType] == TemplateTask::TASK_BRANCH_MAIN_CONDITION_TYPE) {
                //CarId=>lv=>id
                $this->branchMainTaskList[$tpl[TemplateTask::GroupType]][$tpl[TemplateTask::GroupId]] = $tpl[TemplateTask::Id];
            }
            return true;
        }
        if ($tpl[TemplateTask::TaskType] == TemplateTask::TASK_TYPE_MAIN) {
            if ($this->mainTaskId == 0) {
                $this->mainTaskId = $tpl[TemplateTask::Id];
            }
            return true;
        }
        if ($tpl[TemplateTask::TaskType] == TemplateTask::TASK_TYPE_SEASON_WEEK) {
            $this->seasonWeekTaskList[$tpl[TemplateTask::GroupId]][] = $tpl[TemplateTask::Id];
            return true;
        }
        if ($tpl[TemplateTask::TaskType] == TemplateTask::TASK_TYPE_SEASON) {
            $this->seasonTaskList[] = $tpl[TemplateTask::Id];
            return true;
        }
        if ($tpl[TemplateTask::TaskType] == TemplateTask::TASK_TYPE_WELFARE_WEEK) {
            $this->welfareWeekTaskList[$tpl[TemplateTask::GroupId]] = $tpl[TemplateTask::Id];
            return true;
        }
        if ($tpl[TemplateTask::TaskType] == TemplateTask::TASK_TYPE_DAILY_CHALLENGE) {
            $this->dailyChallengeTaskList[] = $tpl[TemplateTask::Id];
            return true;
        }
        if ($tpl[TemplateTask::TaskType] == TemplateTask::TASK_TYPE_FRIEND_INTIMACY) {
            $this->friendIntimacyTaskList[] = $tpl[TemplateTask::Id];
            return true;
        }
        return true;
    }

    public function allTidy($tplIdList): bool
    {
        //校验
        if (empty($this->dailyTaskList) ||
            empty($this->welfareWeekTaskList) ||
            empty($this->branchTaskList) ||
            empty($this->seasonWeekTaskList) ||
            empty($this->seasonTaskList) ||
            empty($this->branchMainTaskList) ||
            empty($this->dailyChallengeTaskList ||
            empty($this->friendIntimacyTaskList)
            )
        ) {
            echo "task type not found";
            return false;
        }
        if ($this->mainTaskId == 0) {
            echo "main task not found";
            return false;
        }
//        var_dump($this->welfareWeekTaskList);
        $this->seasonWeekTaskList[0] = $this->seasonTaskList;
        //保存TemplateInitPlayer
//        $data = $this->getData(TemplateDefine::TYPE_INIT_PLAYER, TemplateInitPlayer::DEFAULT_ID);
//        if (!is_null($data)) {
//            //保存
//            foreach ($data as $key => $value) {
//                $this->addDBArray(TemplateInitPlayer::DEFAULT_ID, $key, $value);
//            }
//        }
        $this->addDBArray(TemplateInitPlayer::DEFAULT_ID, TemplateInitPlayer::DailyTaskList, $this->dailyTaskList);
        $this->addDBArray(TemplateInitPlayer::DEFAULT_ID, TemplateInitPlayer::MainTaskId, $this->mainTaskId);
        $this->addDBArray(TemplateInitPlayer::DEFAULT_ID, TemplateInitPlayer::BranchTaskList, $this->branchTaskList);
        $this->addDBArray(TemplateInitPlayer::DEFAULT_ID, TemplateInitPlayer::BranchMainTaskList, $this->branchMainTaskList);
        $this->addDBArray(TemplateInitPlayer::DEFAULT_ID, TemplateInitPlayer::SeasonTaskList, $this->seasonWeekTaskList);
        $this->addDBArray(TemplateInitPlayer::DEFAULT_ID, TemplateInitPlayer::WelfareWeekTaskList, $this->welfareWeekTaskList);
        $this->addDBArray(TemplateInitPlayer::DEFAULT_ID, TemplateInitPlayer::DailyChallengeTaskList, $this->dailyChallengeTaskList);
        $this->addDBArray(TemplateInitPlayer::DEFAULT_ID, TemplateInitPlayer::FriendIntimacyTaskList, $this->friendIntimacyTaskList);
        return true;
    }
}
