<?php

namespace Tool\LoadTemplate\Tidy;

use Game\Constant\ConstTemplate\TemplateInitPlayer;
use Game\Constant\ConstTemplate\TemplateTale;
use Game\Constant\TemplateDefine;
use Tool\LoadTemplate\ITidy;

class TaleTidy extends ITidy
{
    private array $DrivingLicenseLevel = array();
    private array $DrivingPermitLevel = array();
    private array $DrivingPermitLevelOrder = array();
    private array $teachingSkill = array();
    private array $careerLevel = array();

    public function initTplInfo()
    {
        $this->newTemplateType = TemplateDefine::TYPE_INIT_PLAYER;
    }

    public function singleRowDeal($tpl): bool
    {
        $this->addDrivingLicenseLevel($tpl);
        $this->addDrivingPermitLevel($tpl);
        $this->addDrivingPermitOrder($tpl);
        $this->addteachingSkill($tpl);
        return true;
    }

    public function allTidy($tplIdList): bool
    {
        $this->addCareerLevel($tplIdList);
        if (empty($this->careerLevel)) {
            echo "not found Career Map";
            return false;
        }
        if (empty($this->DrivingLicenseLevel)) {
            echo "not found Driving License Map";
            return false;
        }
        if (empty($this->DrivingPermitLevel)) {
            echo "not found Driving Permit Map";
            return false;
        }
        $data = $this->getData(TemplateDefine::TYPE_INIT_PLAYER, TemplateInitPlayer::DEFAULT_ID);
        if (!is_null($data)) {
            //保存
            foreach ($data as $key => $value) {
                $this->addDBArray(TemplateInitPlayer::DEFAULT_ID, $key, $value);
            }
        }
        $this->addDBArray(TemplateInitPlayer::DEFAULT_ID, TemplateInitPlayer::DrivingLicenseLevel, $this->DrivingLicenseLevel);
        $this->addDBArray(TemplateInitPlayer::DEFAULT_ID, TemplateInitPlayer::DrivingPermitLevel, $this->DrivingPermitLevel);
        $this->addDBArray(TemplateInitPlayer::DEFAULT_ID, TemplateInitPlayer::DrivingPermitLevelOrder, $this->DrivingPermitLevelOrder);
        $this->addDBArray(TemplateInitPlayer::DEFAULT_ID, TemplateInitPlayer::TeachingSkillLevel, $this->teachingSkill);
        $this->addDBArray(TemplateInitPlayer::DEFAULT_ID, TemplateInitPlayer::CareerLevel, $this->careerLevel);
        return true;
    }

    //添加生涯关卡
    private function addCareerLevel(array $tplIdList)
    {
        foreach ($tplIdList as $data) {
            if ($data[TemplateTale::Type] == TemplateTale::TYPE_MAIN || $data[TemplateTale::Type] == TemplateTale::TYPE_BRANCH) {
                if ($tplIdList[$data[TemplateTale::Id]][TemplateTale::Unlock1] == 0){
                    $chapter = $data[TemplateTale::Chapters];
                }else{
                    $chapter = $tplIdList[$data[TemplateTale::Unlock1]][TemplateTale::Chapters];
                }
                $this->careerLevel[$chapter][$data[TemplateTale::Unlock1]][] = $data[TemplateTale::Id];
            }
        }
    }

    //添加驾照关卡
    private function addDrivingLicenseLevel(array $row)
    {
        //驾照关卡检查
        if ($row[TemplateTale::Type] == TemplateTale::TYPE_DRIVING_LICENSE_EXAM) {
            $this->DrivingLicenseLevel[$row[TemplateTale::Chapters]][] = $row[TemplateTale::Id];
        }
    }

    //添加技巧教学关卡
    private function addteachingSkill(array $row)
    {
        //驾照关卡检查
        if ($row[TemplateTale::Type] == TemplateTale::TYPE_TEACHING_SKILL) {
            $this->teachingSkill[$row[TemplateTale::Chapters]][] = $row[TemplateTale::Id];
        }
    }

    //添加驾驶证关卡
    private function addDrivingPermitLevel(array $row)
    {
        if ($row[TemplateTale::Type] == TemplateTale::TYPE_DRIVING_PERMIT) {
            $this->DrivingPermitLevel[$row[TemplateTale::Car]][] = $row[TemplateTale::Id];
        }
    }

    //添加驾驶证关卡顺序
    private function addDrivingPermitOrder(array $row)
    {
        if ($row[TemplateTale::Type] == TemplateTale::TYPE_DRIVING_PERMIT) {
            $this->DrivingPermitLevelOrder[$row[TemplateTale::Car]][$row[TemplateTale::Unlock1]] = $row[TemplateTale::Id];
        }
    }
}
