<?php

/**
 * 赛车商城
 */

namespace Tool\LoadTemplate\Tidy;

use Framework\Logic\TemplateHelp;
use Game\Constant\ConstTemplate\TemplateItem;
use Game\Constant\ConstTemplate\TemplateShopCar;
use Game\Constant\TemplateDefine;
use Tool\LoadTemplate\ITidy;

class ShopCarTidy extends ITidy
{
    use TemplateHelp;

    public function initTplInfo()
    {
        $this->oldTemplateType = TemplateDefine::TYPE_SHOP_CAR;
        $this->newTemplateType = TemplateDefine::TYPE_SHOP_CAR;
    }

    public function allTidy($tplIdList): bool
    {
        foreach ($tplIdList as $key => $value) {
            $itemId = $value[TemplateShopCar::ItemId];
            $itemConfig = $this->getTitle(TemplateDefine::TYPE_ITEM, $itemId);
            if (is_null($itemConfig)) {
                $this->addError("ShopCar itemId not found,id:".(string)$itemId);
                return false;
            }
            if (is_array($itemConfig[TemplateItem::UseId])) {
                $value[TemplateShopCar::CheckItemId] = (int)$itemConfig[TemplateItem::UseId][0];
            } else {
                $value[TemplateShopCar::CheckItemId] = (int)$itemConfig[TemplateItem::UseId];
            }
            $this->addDBRowArray($key, $value);
        }
        return true;
    }

}
