<?php

/**
 * 整理赛季商城道具,把相同赛季的道具id添加到赛季时间表
 */

namespace Tool\LoadTemplate\Tidy;

use Framework\Logic\TemplateHelp;
use Game\Constant\ConstTemplate\TemplateMatchTime;
use Game\Constant\ConstTemplate\TemplateSeasonStore;
use Game\Constant\TemplateDefine;
use Tool\LoadTemplate\ITidy;

class SeasonStoreTidy extends ITidy
{
    use TemplateHelp;

    private array $shopItemIds = array();       //赛季id=>[id,..]
    private array $shopWeekResetIds = array();  //赛季id=>[id,..]
    private array $shopForeverIds = array();    //赛季id=>[id,..]
    private array $shopDailyResetIds = array();

    public function initTplInfo()
    {
        $this->newTemplateType = TemplateDefine::TYPE_MATCH_TIME;
    }

    public function allTidy($tplIdList): bool
    {
        //整理赛季商店道具
        foreach ($tplIdList as $id => $data) {
            foreach ($data[TemplateSeasonStore::SeasonId] as $seasonId) {
                $this->shopItemIds[$seasonId][] = $id;
                switch ($data[TemplateSeasonStore::Term]) {
                    case TemplateSeasonStore::TERM_TYPE_WEEK:
                        //每周限购
                        $this->shopWeekResetIds[$seasonId][] = $id;
                        break;
                    case TemplateSeasonStore::TERM_TYPE_FOREVER:
                        //永久
                        $this->shopForeverIds[$seasonId][] = $id;
                        break;
                    case TemplateSeasonStore::TERM_TYPE_DAILY:
                        //每日限购
                        $this->shopDailyResetIds[$seasonId][] = $id;
                        break;
                }
            }
        }
        $seasonTimeConfig = $this->getTable(TemplateDefine::TYPE_MATCH_TIME);
        foreach ($seasonTimeConfig as $seasonId => $data) {
            $data[TemplateMatchTime::ShopItemIds] = $this->shopItemIds[$seasonId] ?? array();
            $data[TemplateMatchTime::ShopItemWeekResetIds] = $this->shopWeekResetIds[$seasonId] ?? array();
            $data[TemplateMatchTime::ShopItemForeverIds] = $this->shopForeverIds[$seasonId] ?? array();
            $data[TemplateMatchTime::ShopItemDailyResetIds] = $this->shopDailyResetIds[$seasonId] ?? array();
            $this->addDBRowArray($seasonId, $data);
        }
        return true;
    }
}
