<?php
/**
 *
 * @date 2022-3-16
 * @author JZW
 **/


namespace Tool\LoadTemplate\Tidy;


use Game\Constant\ConstTemplate\TemplateRandomId;
use Game\Constant\TemplateDefine;
use Tool\LoadTemplate\ITidy;

class RandomIdTidy extends ITidy
{
    public function initTplInfo()
    {
        $this->newTemplateType = TemplateDefine::TYPE_RANDOM_ID;
        $this->oldTemplateType = TemplateDefine::TYPE_RANDOM_ID;
    }

    public function allTidy($tplIdList): bool
    {
        $tmp = [0 => [1, 2, 3]];
        foreach ($tplIdList as $data) {
            $tmp[1][$data[TemplateRandomId::Id]] = $this->checkNameIsNone($data[TemplateRandomId::Front_w]);
            $tmp[2][$data[TemplateRandomId::Id]] = $this->checkNameIsNone($data[TemplateRandomId::After_w]);
            $tmp[3][$data[TemplateRandomId::Id]] =$this->checkNameIsNone( $data[TemplateRandomId::Suffix]);
        }
        $this->dbArray = $tmp;
        return true;
    }

    private function checkNameIsNone(string $name): string
    {
        if ($name == "None") {
            return "";
        }
        return $name;
    }


}