<?php

namespace Tool\LoadTemplate\Tidy;

use Game\Constant\ConstTemplate\TemplateInitPlayer;
use Game\Constant\ConstTemplate\TemplatePlayerLevel;
use Game\Constant\TemplateDefine;
use Tool\LoadTemplate\ITidy;

class PlayerLevelTidy extends ITidy
{
    private array $unlockFunc2Level = array();

    public function initTplInfo()
    {
        $this->newTemplateType = TemplateDefine::TYPE_INIT_PLAYER;
    }

    public function singleRowDeal($tpl): bool
    {
        foreach ($tpl[TemplatePlayerLevel::FunctionID] as $fId) {
            $this->unlockFunc2Level[$fId] = $tpl[TemplatePlayerLevel::Level];
        }
        return true;
    }
    public function allTidy($tplIdList): bool
    {
        $data = $this->getData(TemplateDefine::TYPE_INIT_PLAYER, TemplateInitPlayer::DEFAULT_ID);
        if (!is_null($data)) {
            //保存
            foreach ($data as $key => $value) {
                $this->addDBArray(TemplateInitPlayer::DEFAULT_ID, $key, $value);
            }
        }
        $this->addDBArray(TemplateInitPlayer::DEFAULT_ID, TemplateInitPlayer::UnlockFunc2Level, $this->unlockFunc2Level);
        return true;
    }
}
