<?php

namespace Tool\LoadTemplate\Tidy;

use Framework\Logic\TemplateHelp;
use Game\Constant\ConstTemplate\TemplateClothing;
use Game\Constant\ConstTemplate\TemplateCreateRole;
use Game\Constant\ConstTemplate\TemplateHeadModel;
use Game\Constant\ConstTemplate\TemplateItem;
use Game\Constant\ConstTemplate\TemplatePlayerLevel;
use Game\Constant\TemplateDefine;
use Tool\LoadTemplate\ITidy;

class PlayerHeadTidy extends ITidy
{
    use TemplateHelp;

    public function initTplInfo()
    {
        $this->oldTemplateType = TemplateDefine::TYPE_PLAYER_HEAD_MODEL;
        $this->newTemplateType = TemplateDefine::TYPE_CREATE_ROLE;
    }

    public function allTidy($tplIdList): bool
    {
        //第一级奖励
        $reward = $this->getTerm(TemplateDefine::TYPE_PLAYER_LEVEL, 1, TemplatePlayerLevel::Reward);
        $config = $this->getTable(TemplateDefine::TYPE_CREATE_ROLE);
        foreach ($config as $id => $configData) {
            $hId = $configData[TemplateCreateRole::HeadModelId];
            if (!isset($tplIdList[$hId])) {
                echo "not found HeadModel Id:{$hId} \n";
                return false;
            }
            $configData[TemplateCreateRole::SkinColor] = $tplIdList[$hId][TemplateHeadModel::SkinColor];
            //第一级奖励加到初始道具中
            foreach ($reward as $itemId => $num) {
                $configItemData = $this->getTitle( TemplateDefine::TYPE_ITEM, $itemId);
                if (is_null($configItemData)) {
                    return false;
                }
                switch($configItemData[TemplateItem::ItemType]) {
                    case TemplateItem::ITEM_TYPE_CAR :
                        //转成对应CarId=>过期时间
                        $configData[TemplateCreateRole::InitCar][$itemId] = $configItemData[TemplateItem::UseId];
                        break;
                    case TemplateItem::ITEM_TYPE_MONEY:
                        isset($configData[TemplateCreateRole::InitMoney][$itemId]) ?
                            $configData[TemplateCreateRole::InitMoney][$itemId] += $num :
                            $configData[TemplateCreateRole::InitMoney][$itemId] = $num;
                        break;
                    default:
                        isset($configData[TemplateCreateRole::InitItem][$itemId]) ?
                            $configData[TemplateCreateRole::InitItem][$itemId] += $num :
                            $configData[TemplateCreateRole::InitItem][$itemId] = $num;
                        break;
                }
            }
            $this->addDBRowArray($id, $configData);
        }
        return true;
    }
}
