<?php

namespace Tool\LoadTemplate\Tidy;

use Game\Constant\ConstTemplate\TemplateMail;
use Game\Constant\TemplateDefine;
use Tool\LoadTemplate\ITidy;

class MailTidy extends ITidy
{
    public function initTplInfo()
    {
        $this->newTemplateType = TemplateDefine::TYPE_MAIL;
        $this->oldTemplateType = TemplateDefine::TYPE_MAIL;
    }

    public function singleRowDeal($tpl): bool
    {
        //检查附件道具是否存在
        $enclosure = $tpl[TemplateMail::Enclosure];  //array(itemId=>num)
        foreach ($enclosure as $itemId => $num) {
            if (false == $this->checkItemExist($itemId)) {
                $this->addError("Mail item id not found,id:".(string)$itemId);
                return false;
            }
        }
        $this->dbArray[$tpl[TemplateMail::Id]] = $tpl;
        return true;
    }

    private function checkItemExist(int $itemId): bool
    {
        $configItemData = $this->getData( TemplateDefine::TYPE_ITEM, $itemId);
        if (is_null($configItemData)) {
            return false;
        }
        return true;
    }
}
