<?php

namespace Tool\LoadTemplate\Tidy;

use Framework\Logic\TemplateHelp;
use Game\Constant\ConstTemplate\TemplateAI;
use Game\Constant\ConstTemplate\TemplateClothing;
use Game\Constant\ConstTemplate\TemplateGuideAI;
use Game\Constant\ConstTemplate\TemplateHeadModel;
use Game\Constant\TemplateDefine;
use Game\Protobuf\ClothData;
use Tool\LoadTemplate\ITidy;

class GuideAiTidy extends ITidy
{
    use TemplateHelp;

    public function initTplInfo()
    {
        $this->oldTemplateType = TemplateDefine::TYPE_GUIDE_AI;
        $this->newTemplateType = TemplateDefine::TYPE_GUIDE_AI;
    }

    public function singleRowDeal($tpl): bool
    {
        $aiId = $tpl[TemplateGuideAI::Id];
        foreach ($tpl as $key => $value) {
            $this->addDBArray($aiId, $key, $value);
        }
        //AI表信息
        $aiInfo = $this->getTitle(TemplateDefine::TYPE_AI, $aiId);
        if (is_null($aiInfo)) {
            $this->addError("GuideAiTidy AI not found,id:".(string)$aiId);
            return false;
        }
        $this->addDBArray($aiId, TemplateGuideAI::CarId, $aiInfo[TemplateAI::CarId]);
        $this->addDBArray($aiId, TemplateGuideAI::CarLevel, $aiInfo[TemplateAI::CarLevel]);
        $this->addDBArray($aiId, TemplateGuideAI::Nickname, $aiInfo[TemplateAI::Nickname]);
        //HeadModel表
        $headModelConfig = $this->getTitle(TemplateDefine::TYPE_PLAYER_HEAD_MODEL, $tpl[TemplateGuideAI::HeadModel]);
        if (is_null($headModelConfig)) {
            $this->addError("GuideAiTidy AI headModel not found,id:".(string)$tpl[TemplateGuideAI::HeadModel]);
            return false;
        }
        $this->addDBArray($aiId, TemplateGuideAI::SkinColor, $headModelConfig[TemplateHeadModel::SkinColor]);
        //整理服装
        $cloth = new ClothData();
        foreach ($tpl[TemplateGuideAI::ClothData] as $clothId) {
            if($clothId == "0") {
                continue;
            }
            $clothConfig = $this->getTitle(TemplateDefine::TYPE_CLOTHING, $clothId);
            switch($clothConfig[TemplateClothing::Part]) {
                case 1:  $cloth->setHairId($clothId); break;
                case 2:  $cloth->setFaceId($clothId); break;
                case 3:  $cloth->setUpClothId($clothId); break;
                case 4:  $cloth->setDownClothId($clothId); break;
                case 5:  $cloth->setShoesId($clothId); break;
            }
        }
        $clothJson = $cloth->serializeToJsonString();
        $this->addDBArray($aiId, TemplateGuideAI::ClothProtoJson, $clothJson);
        return true;
    }
}
