<?php
/**
 *
 * @date 2022-3-22
 * @author JZW
 **/


namespace Tool\LoadTemplate\Tidy;


use Game\Constant\TemplateDefine;
use Tool\LoadTemplate\ITidy;

class DeepmodTidy extends ITidy
{

    public function initTplInfo()
    {
        $this->newTemplateType = TemplateDefine::TYPE_DEEPMOD;
        $this->oldTemplateType = TemplateDefine::TYPE_DEEPMOD;
    }

    public function allTidy($tplIdList): bool
    {
        $tmp = [0 => []];

        foreach ($tplIdList as $data) {
            if(!array_key_exists("Sys_id", $data)){
                continue;
            }

            if(!in_array($data["Sys_id"], $tmp[0])){
                $tmp[0][] = $data["Sys_id"];
                $tmp[$data["Sys_id"]] = [];
            }
            $tmp[$data["Sys_id"]][1][$data["Unlock_grade"]][] = $data["Id"];  // 每个解锁等级下对应的属性Id Unlock_grade => Id
            $tmp[$data["Sys_id"]][2][$data["Type_att"]][$data["Limit"]][$data["Quality"]] = $data["Inc_max"];  //
            // 等级=>最大上限
            // 车辆等级对应的最大上限值
            $tmp[$data["Sys_id"]][3][$data["Type_att"]][$data["Id"]] = $data["Limit"];  //  每个系统下属性类型对应的Id=>车辆等级
            $tmp[$data["Sys_id"]][$data["Id"]] = [
                "Type_att" => $data["Type_att"],
                "Inc_min" => $data["Inc_min"],
                "Inc_max" => $data["Inc_max"],
                "Section_f" => $data["Section_f"],
                "Section_l" => $data["Section_l"],
                "Ratio" => $data["Ratio"],
                "Limit" => $data["Limit"],
                "Unlock_grade" => $data["Unlock_grade"],
                "Quality" => $data["Quality"],
            ];
        }
        $this->dbArray = $tmp;
        return true;
    }
}