<?php

namespace Tool\LoadTemplate\Tidy;

use Game\Constant\ConstTemplate\TemplateClothing;
use Game\Constant\ConstTemplate\TemplateItem;
use Game\Constant\TemplateDefine;
use Tool\LoadTemplate\ITidy;
use Framework\Logic\TemplateHelp;

class ClothingTidy extends ITidy
{
    use TemplateHelp;
    public function initTplInfo()
    {
        $this->newTemplateType = TemplateDefine::TYPE_ITEM;
    }

    public function singleRowDeal($data): bool
    {
        return true;
    }

    public function allTidy($tplIdList): bool
    {
        $itemArr = [];
        foreach($tplIdList as $k => $v) {
            if(!empty($v[TemplateClothing::SuitID])) {
                $itemArr[$v[TemplateClothing::SuitID]][] = $k;
            }
        }

        $data =  $this->getTable(TemplateDefine::TYPE_ITEM);
        //保存
        foreach ($data as $key => $value) {
            $this->addDBRowArray($key, $value);
        }

        foreach($itemArr as $cloth => $item) {
            $this->addDBArray($cloth, TemplateItem::ClothList, array_values($item));
        }
        return true;
    }
}
