<?php

/**
 * 战令商城
 */

namespace Tool\LoadTemplate\Logic;

use Game\Constant\ConstTemplate\TemplateBPStore;
use Game\Constant\TemplateDefine;
use Tool\LoadTemplate\Config;
use Tool\LoadTemplate\ILogic;
use Tool\LoadTemplate\Util;

class ZLStoreLogic extends ILogic
{
    public function dealRow(&$row): bool
    {
        $row[TemplateBPStore::Id] = (int)$row[TemplateBPStore::Id];
        $row[TemplateBPStore::ItemId] = (int)$row[TemplateBPStore::ItemId];
        $row[TemplateBPStore::Num] = (int)$row[TemplateBPStore::Num];
        $row[TemplateBPStore::Term] = (int)$row[TemplateBPStore::Term];
        $row[TemplateBPStore::MaxNum] = (int)$row[TemplateBPStore::MaxNum];
        $row[TemplateBPStore::ConvertedType] = (int)$row[TemplateBPStore::ConvertedType];
        $row[TemplateBPStore::Price] = (int)$row[TemplateBPStore::Price];
        //赛季
        $row[TemplateBPStore::SeasonId] = Util::getFormatArrayToSemicolon($row[TemplateBPStore::SeasonId]);
        return true;
    }

    public function getTidyList(): array
    {
        return array(
            Config::TIDY_DEFINE[TemplateDefine::TYPE_SHOP_ZL]
        );
    }
}
