<?php
/**
 * 战令奖励
 */

namespace Tool\LoadTemplate\Logic;

use Game\Constant\ConstTemplate\TemplateZLReward;
use Tool\LoadTemplate\ILogic;
use Tool\LoadTemplate\Util;

class ZLRewardLogic extends ILogic
{
    public function dealKey($key, $val, &$title): bool
    {
        $title [$key] = $val;
        return true;
    }

    public function dealRow(&$row): bool
    {
        $row[TemplateZLReward::Lv] = intval($row[TemplateZLReward::Lv]);
        $row[TemplateZLReward::Primary] = Util::getFormatArray($row[TemplateZLReward::Primary]);
        $row[TemplateZLReward::Expert] = Util::getFormatArray($row[TemplateZLReward::Expert]);
        $row[TemplateZLReward::Elite] = Util::getFormatArray($row[TemplateZLReward::Elite]);
        return true;
    }

    public function dealFile(&$file): bool
    {
        return true;
    }

    public function getTidyList(): array
    {
        return array();
    }
}