<?php

/**
 * 限时目标任务
 */

namespace Tool\LoadTemplate\Logic;

use Game\Constant\ConstTemplate\TemplateTaskTarget;
use Tool\LoadTemplate\ILogic;
use Tool\LoadTemplate\Util;

class TaskTargetLogic extends ILogic
{
    public function dealRow(&$row): bool
    {
        $row[TemplateTaskTarget::Id] = (int)$row[TemplateTaskTarget::Id];
        $row[TemplateTaskTarget::TaskType] = (int)$row[TemplateTaskTarget::TaskType];
        $row[TemplateTaskTarget::TaskId] = Util::getFormatArrayToSemicolon($row[TemplateTaskTarget::TaskId]);

        //计算上下架时间
        $sTime = $eTime = 0;
        if (false == Util::StringToTime($row[TemplateTaskTarget::SDate]. " " .$row[TemplateTaskTarget::STime], $sTime)) {
            return false;
        }
        if (false == Util::StringToTime($row[TemplateTaskTarget::EDate]. " " .$row[TemplateTaskTarget::ETime], $eTime)) {
            return false;
        }
        $row[TemplateTaskTarget::StartTime] = $sTime;
        $row[TemplateTaskTarget::EndTime] = $eTime;

        return true;
    }

    public function getTidyList(): array
    {
        return array();
    }
}
