<?php

namespace Tool\LoadTemplate\Logic;

use Game\Constant\ConstTemplate\TemplateTaskLogin;
use Tool\LoadTemplate\ILogic;
use Tool\LoadTemplate\Util;

class TaskLoginLogic extends ILogic
{
    public function dealKey($key, $val, &$title): bool
    {
        $title [$key] = $val;
        return true;
    }

    /**
     * @param $row
     * @return bool
     * 处理数据 对UseId和TimeLimit字段检查
     */
    public function dealRow(&$row): bool
    {
        $row[TemplateTaskLogin::Id] = (int)($row[TemplateTaskLogin::Id]);
        $row[TemplateTaskLogin::Vitality] = (int)($row[TemplateTaskLogin::Vitality]);
        $row[TemplateTaskLogin::Reward] = Util::getFormatArray($row[TemplateTaskLogin::Reward]);

        return true;
    }

    public function dealFile(&$file): bool
    {
        return true;
    }

    public function getTidyList(): array
    {
        return array();
    }
}