<?php
/**
 * 任务
 */

namespace Tool\LoadTemplate\Logic;

use Game\Constant\ConstTemplate\TemplateTask;
use Game\Constant\TaskLogicDefine;
use Game\Constant\TemplateDefine;
use Tool\LoadTemplate\Config;
use Tool\LoadTemplate\ILogic;
use Tool\LoadTemplate\Util;

class TaskLogic extends ILogic
{
    public function dealKey($key, $val, &$title): bool
    {
        $title [$key] = $val;
        return true;
    }

    /**
     * @param $row
     * @return bool
     * 处理附件
     */
    public function dealRow(&$row): bool
    {
        $row[TemplateTask::Id] = (int)$row[TemplateTask::Id];
        $row[TemplateTask::TaskType] = (int)$row[TemplateTask::TaskType];
        $row[TemplateTask::GroupType] = (int)$row[TemplateTask::GroupType];
        $row[TemplateTask::GroupId] = (int)$row[TemplateTask::GroupId];
        $row[TemplateTask::ConditionType] = (int)$row[TemplateTask::ConditionType];
        $row[TemplateTask::Target] = (int)$row[TemplateTask::Target];
        $row[TemplateTask::TargetHandle] = (int)$row[TemplateTask::TargetHandle];
        $row[TemplateTask::NumReward] = (int)$row[TemplateTask::NumReward];
        $row[TemplateTask::NextTask] = (int)$row[TemplateTask::NextTask];
        $row[TemplateTask::EXP] = (int)$row[TemplateTask::EXP];
        //检查任务条件
        if (in_array($row[TemplateTask::ConditionType], TaskLogicDefine::MULTIPLE_CONDITIONS_TASK)) {
            if (is_numeric($row[TemplateTask::Condition])) {
                $row[TemplateTask::Condition] = array(array((int)$row[TemplateTask::Condition]));
            } else {
                $row[TemplateTask::Condition] = Util::getFormatArray5($row[TemplateTask::Condition]);
            }
        } else {
            //特殊条件
            if (is_numeric($row[TemplateTask::Condition])) {
                $row[TemplateTask::Condition] = (int)$row[TemplateTask::Condition];
            } else {
                $row[TemplateTask::Condition] = Util::getFormatArray5($row[TemplateTask::Condition]);
            }
        }
        //道具奖励
        if ($row[TemplateTask::Reward] == "0") {
            $row[TemplateTask::Reward] = array();
        } else {
            $row[TemplateTask::Reward] = Util::getFormatArray($row[TemplateTask::Reward]);
        }
        return true;
    }

    public function dealFile(&$file): bool
    {
        return true;
    }

    public function getTidyList(): array
    {
        return array(
            Config::TIDY_DEFINE[TemplateDefine::TYPE_TASK]
        );
    }
}
