<?php

/**
 * 限时节日任务
 */

namespace Tool\LoadTemplate\Logic;

use Game\Constant\ConstTemplate\TemplateTaskFestival;
use Tool\LoadTemplate\ILogic;
use Tool\LoadTemplate\Util;

class TaskFestivalLogic extends ILogic
{
    public function dealRow(&$row): bool
    {
        $row[TemplateTaskFestival::Id] = (int)$row[TemplateTaskFestival::Id];
        $row[TemplateTaskFestival::UseType] = (int)$row[TemplateTaskFestival::UseType];
        $row[TemplateTaskFestival::TaskType] = (int)$row[TemplateTaskFestival::TaskType];
        $row[TemplateTaskFestival::TaskId] = Util::getFormatArrayToSemicolon($row[TemplateTaskFestival::TaskId]);

        //计算上下架时间
        $sTime = $eTime = 0;
        if (false == Util::StringToTime($row[TemplateTaskFestival::SDate]. " " .$row[TemplateTaskFestival::STime], $sTime)) {
            return false;
        }
        if (false == Util::StringToTime($row[TemplateTaskFestival::EDate]. " " .$row[TemplateTaskFestival::ETime], $eTime)) {
            return false;
        }
        $row[TemplateTaskFestival::StartTime] = $sTime;
        $row[TemplateTaskFestival::EndTime] = $eTime;

        return true;
    }

    public function getTidyList(): array
    {
        return array();
    }
}
