<?php

/**
 * 兑换商城
 */

namespace Tool\LoadTemplate\Logic;

use Game\Constant\ConstTemplate\TemplateTaskExchange;
use Tool\LoadTemplate\ILogic;
use Tool\LoadTemplate\Util;

class TaskExchangeLogic extends ILogic
{
    public function dealRow(&$row): bool
    {
        $row[TemplateTaskExchange::Id] = (int)$row[TemplateTaskExchange::Id];
        $row[TemplateTaskExchange::TaskType] = (int)$row[TemplateTaskExchange::TaskType];
        $row[TemplateTaskExchange::TaskId] = Util::getFormatArrayToSemicolon($row[TemplateTaskExchange::TaskId]);

        //计算上下架时间
        $sTime = $eTime = 0;
        if (false == Util::StringToTime($row[TemplateTaskExchange::SDate]. " " .$row[TemplateTaskExchange::STime], $sTime)) {
            return false;
        }
        if (false == Util::StringToTime($row[TemplateTaskExchange::EDate]. " " .$row[TemplateTaskExchange::ETime], $eTime)) {
            return false;
        }
        $row[TemplateTaskExchange::StartTime] = $sTime;
        $row[TemplateTaskExchange::EndTime] = $eTime;

        return true;
    }

    public function getTidyList(): array
    {
        return array();
    }
}
