<?php

/**
 * 剧情和驾照考试
 */

namespace Tool\LoadTemplate\Logic;

use Game\Constant\ConstTemplate\TemplateTale;
use Game\Constant\TemplateDefine;
use Tool\LoadTemplate\Config;
use Tool\LoadTemplate\ILogic;
use Tool\LoadTemplate\Util;

class TaleLogic  extends ILogic
{
    public function dealKey($key, $val, &$title): bool
    {
        $title [$key] = $val;
        return true;
    }

    /**
     * @param $row
     * @return bool
     * 处理附件
     */
    public function dealRow(&$row): bool
    {
        $row[TemplateTale::Id] = (int)$row[TemplateTale::Id];
        $row[TemplateTale::Type] = (int)($row[TemplateTale::Type]);
        $row[TemplateTale::Chapters] = (int)($row[TemplateTale::Chapters]);
        $row[TemplateTale::GatedType] = (int)($row[TemplateTale::GatedType]);
        $row[TemplateTale::Car] = (int)($row[TemplateTale::Car]);
        $row[TemplateTale::Rank] = (int)($row[TemplateTale::Rank]);
        $row[TemplateTale::VitalTargetType] = (int)($row[TemplateTale::VitalTargetType]);
        $row[TemplateTale::VitalTargetCondition] = (int)($row[TemplateTale::VitalTargetCondition]);
        //次要条件检查
        if ($row[TemplateTale::TargetType1] == "None") {
            $row[TemplateTale::TargetType1] = 0;
        } else {
            $row[TemplateTale::TargetType1] = (int)($row[TemplateTale::TargetType1]);
        }
        $row[TemplateTale::TargetCondition1] = (int)($row[TemplateTale::TargetCondition1]);
        if ($row[TemplateTale::TargetType2] == "None") {
            $row[TemplateTale::TargetType2] = 0;
        } else {
            $row[TemplateTale::TargetType2] = (int)($row[TemplateTale::TargetType2]);
        }
        $row[TemplateTale::TargetCondition2] = (int)($row[TemplateTale::TargetCondition2]);
        $row[TemplateTale::Unlock1] = (int)($row[TemplateTale::Unlock1]);
        $row[TemplateTale::Unlock2] = (int)($row[TemplateTale::Unlock2]);
        //奖励
        $row[TemplateTale::Reward] = Util::getFormatArray4($row[TemplateTale::Reward]);
        $row[TemplateTale::EXP] = (int)($row[TemplateTale::EXP]);
        $row[TemplateTale::SkillTeachId] = (int)($row[TemplateTale::SkillTeachId]);
        return true;
    }

    public function dealFile(&$file): bool
    {
        return true;
    }

    public function getTidyList(): array
    {
        return array(
            Config::TIDY_DEFINE[TemplateDefine::TYPE_TALE],
        );
    }
}
