<?php

namespace Tool\LoadTemplate\Logic;

use Game\Constant\ConstTemplate\TemplateSkinAttribution;
use Tool\LoadTemplate\ILogic;

class SkinAttributionLogic extends ILogic
{
    public function dealKey($key, $val, &$title): bool
    {
        $title [$key] = $val;
        return true;
    }

    /**
     * @param $row
     * @return bool
     * 需要字段转为int
     */
    public function dealRow(&$row): bool
    {
        $row[TemplateSkinAttribution::Id] = (int)$row[TemplateSkinAttribution::Id];
        $row[TemplateSkinAttribution::CarId] = (int)$row[TemplateSkinAttribution::CarId];
        $row[TemplateSkinAttribution::Individual] = (int)$row[TemplateSkinAttribution::Individual];
        return true;
    }

    public function dealFile(&$file): bool
    {
        return true;
    }

    public function getTidyList(): array
    {
        return array();
    }
}