<?php

/**
 * 推荐商城
 */

namespace Tool\LoadTemplate\Logic;

use Game\Constant\ConstTemplate\TemplateShopRecommend;
use Tool\LoadTemplate\ILogic;
use Tool\LoadTemplate\Util;

class ShopRecommendLogic extends ILogic
{
    public function dealRow(&$row): bool
    {
        $row[TemplateShopRecommend::ItemId] = Util::getFormatArray3($row[TemplateShopRecommend::ItemId]);
        $row[TemplateShopRecommend::Access] = (int)$row[TemplateShopRecommend::Access];
        //计算上下架时间
        $sTime = $eTime = 0;
        if (false == Util::StringToTime($row[TemplateShopRecommend::SDate]. " " .$row[TemplateShopRecommend::STime], $sTime)) {
            return false;
        }
        if (false == Util::StringToTime($row[TemplateShopRecommend::EDate]. " " .$row[TemplateShopRecommend::ETime], $eTime)) {
            return false;
        }
        $row[TemplateShopRecommend::StartTime] = $sTime;
        $row[TemplateShopRecommend::EndTime] = $eTime;
        return true;
    }
}
