<?php

/**
 * 兑换商城
 */

namespace Tool\LoadTemplate\Logic;

use Game\Constant\ConstTemplate\TemplateShopExchange;
use Tool\LoadTemplate\ILogic;
use Tool\LoadTemplate\Util;

class ShopExchangeLogic extends ILogic
{
    public function dealRow(&$row): bool
    {
        $row[TemplateShopExchange::Id] = (int)$row[TemplateShopExchange::Id];
        $row[TemplateShopExchange::Item] = (int)$row[TemplateShopExchange::Item];
        $row[TemplateShopExchange::ItemNum] = (int)$row[TemplateShopExchange::ItemNum];
        $row[TemplateShopExchange::RewardItem] = Util::getFormatArrayToSemicolon($row[TemplateShopExchange::RewardItem]);
        $row[TemplateShopExchange::ItemType] = (int)$row[TemplateShopExchange::ItemType];
        $row[TemplateShopExchange::RewardItemNum] = (int)$row[TemplateShopExchange::RewardItemNum];
        $row[TemplateShopExchange::Exchange] = (int)$row[TemplateShopExchange::Exchange];
        $row[TemplateShopExchange::Term] = (int)$row[TemplateShopExchange::Term];

        return true;
    }

    public function getTidyList(): array
    {
        return array();
    }
}
