<?php

/**
 * 服装商城
 */

namespace Tool\LoadTemplate\Logic;

use Game\Constant\ConstTemplate\TemplateShopClothing;
use Tool\LoadTemplate\ILogic;
use Tool\LoadTemplate\Util;

class ShopClothingLogic extends ILogic
{
    public function dealRow(&$row): bool
    {
        $row[TemplateShopClothing::UseType] = (int)$row[TemplateShopClothing::UseType];
        $row[TemplateShopClothing::ItemId] = (int)$row[TemplateShopClothing::ItemId];
        $row[TemplateShopClothing::Num] = (int)$row[TemplateShopClothing::Num];
        $row[TemplateShopClothing::ConvertedType] = (int)$row[TemplateShopClothing::ConvertedType];
        $row[TemplateShopClothing::Price] = (int)$row[TemplateShopClothing::Price];
        $row[TemplateShopClothing::ShowType] = (int)$row[TemplateShopClothing::ShowType];
        //计算上下架时间
        $sTime = $eTime = 0;
        if (false == Util::StringToTime($row[TemplateShopClothing::SDate]. " " .$row[TemplateShopClothing::STime], $sTime)) {
            return false;
        }
        if (false == Util::StringToTime($row[TemplateShopClothing::EDate]. " " .$row[TemplateShopClothing::ETime], $eTime)) {
            return false;
        }
        $row[TemplateShopClothing::StartTime] = $sTime;
        $row[TemplateShopClothing::EndTime] = $eTime;
        //计算真实价格 价格*折扣
        if ($row[TemplateShopClothing::Discount] == "0") {
            $row[TemplateShopClothing::RealPrice] = $row[TemplateShopClothing::Price];
        } else {
            $row[TemplateShopClothing::RealPrice] = $row[TemplateShopClothing::Price] * (int)$row[TemplateShopClothing::Discount] / 100;
        }
        return true;
    }

    public function getTidyList(): array
    {
        return array();
    }
}
