<?php

/**
 * 赛车商城
 */

namespace Tool\LoadTemplate\Logic;

use Game\Constant\ConstTemplate\TemplateShopCar;
use Game\Constant\TemplateDefine;
use Tool\LoadTemplate\Config;
use Tool\LoadTemplate\ILogic;
use Tool\LoadTemplate\Util;

class ShopCarLogic extends ILogic
{
    public function dealRow(&$row): bool
    {
        $row[TemplateShopCar::UseType] = (int)$row[TemplateShopCar::UseType];
        $row[TemplateShopCar::ItemId] = (int)$row[TemplateShopCar::ItemId];
        $row[TemplateShopCar::Num] = (int)$row[TemplateShopCar::Num];
        $row[TemplateShopCar::ConvertedType] = (int)$row[TemplateShopCar::ConvertedType];
        $row[TemplateShopCar::Price] = (int)$row[TemplateShopCar::Price];
        $row[TemplateShopCar::ShowType] = (int)$row[TemplateShopCar::ShowType];
        //计算上下架时间
        $sTime = $eTime = 0;
        if (false == Util::StringToTime($row[TemplateShopCar::SDate]. " " .$row[TemplateShopCar::STime], $sTime)) {
            return false;
        }
        if (false == Util::StringToTime($row[TemplateShopCar::EDate]. " " .$row[TemplateShopCar::ETime], $eTime)) {
            return false;
        }
        $row[TemplateShopCar::StartTime] = $sTime;
        $row[TemplateShopCar::EndTime] = $eTime;
        //计算真实价格 价格*折扣
        if ($row[TemplateShopCar::Discount] == "0") {
            $row[TemplateShopCar::RealPrice] = $row[TemplateShopCar::Price];
        } else {
            $row[TemplateShopCar::RealPrice] = $row[TemplateShopCar::Price] * (int)$row[TemplateShopCar::Discount] / 100;
        }
        return true;
    }

    public function getTidyList(): array
    {
        return array(
            Config::TIDY_DEFINE[TemplateDefine::TYPE_SHOP_CAR]
        );
    }
}
