<?php

/**
 * 盲盒商城
 */

namespace Tool\LoadTemplate\Logic;

use Game\Constant\ConstTemplate\TemplateShopBlindBox;
use Tool\LoadTemplate\ILogic;
use Tool\LoadTemplate\Util;

class ShopBlindBoxLogic extends ILogic
{
    public function dealRow(&$row): bool
    {
        $row[TemplateShopBlindBox::ItemBox1] = (int)$row[TemplateShopBlindBox::ItemBox1];
        $row[TemplateShopBlindBox::PR1] = (int)$row[TemplateShopBlindBox::PR1];
        $row[TemplateShopBlindBox::Minimum1] = Util::getFormatArray3($row[TemplateShopBlindBox::Minimum1]);
        $row[TemplateShopBlindBox::Weight] = Util::getFormatArray3($row[TemplateShopBlindBox::Weight]);
        for ($i = TemplateShopBlindBox::START_NUM; $i <= TemplateShopBlindBox::END_NUM; $i++) {
            $key = TemplateShopBlindBox::ITEM_KEY.$i;
            if ($row[$key] == "None") {
                $row[$key] = 0;
            } else {
                $row[$key] = (int)$row[$key];
                $row[TemplateShopBlindBox::PR_KEY.$i] = (int)$row[TemplateShopBlindBox::PR_KEY.$i];
                $row[TemplateShopBlindBox::MINIMUM_KEY.$i] =
                    Util::getFormatArray3($row[TemplateShopBlindBox::MINIMUM_KEY.$i]);
            }
        }
        //价格统一用price
        if ($row[TemplateShopBlindBox::MoneyType] == "None") {
            $row[TemplateShopBlindBox::MoneyType] = 0;
            $row[TemplateShopBlindBox::TicketType] = (int)$row[TemplateShopBlindBox::TicketType];
            $row[TemplateShopBlindBox::Price] = (int)$row[TemplateShopBlindBox::Num];
        } else {
            $row[TemplateShopBlindBox::TicketType] = 0;
            $row[TemplateShopBlindBox::MoneyType] = (int)$row[TemplateShopBlindBox::MoneyType];
            $row[TemplateShopBlindBox::Price] = (int)$row[TemplateShopBlindBox::Price];
        }
        //计算上下架时间
        $sTime = $eTime = 0;
        if (false == Util::StringToTime($row[TemplateShopBlindBox::SDate]. " " .$row[TemplateShopBlindBox::STime], $sTime)) {
            return false;
        }
        if (false == Util::StringToTime($row[TemplateShopBlindBox::EDate]. " " .$row[TemplateShopBlindBox::ETime], $eTime)) {
            return false;
        }
        $row[TemplateShopBlindBox::StartTime] = $sTime;
        $row[TemplateShopBlindBox::EndTime] = $eTime;
        return true;
    }
}
