<?php

namespace Tool\LoadTemplate\Logic;

use Game\Constant\ConstTemplate\TemplateShieldWords;
use Tool\LoadTemplate\ILogic;

class ShieldWordsLogic extends ILogic
{
    private const MAX_NUM = 5000;   //每组包含敏感词数量
    private int $i = 1;
    private int $t = 0;
    private array $shieldWordsList = array();

    public function dealRow(&$row): bool
    {
        $this->shieldWordsList[$this->i][trim($row[TemplateShieldWords::ShieldWord])] = "*";
        $this->t++;
        if ($this->t >= self::MAX_NUM) {
            $this->i++;
            $this->t = 0;
        }
        return true;
    }

    public function dealFile(&$file): bool
    {
        $file = $this->shieldWordsList;
        return true;
    }

    public function getTidyList(): array
    {
        return array();
    }
}
