<?php

/**
 * 赛季商城
 */

namespace Tool\LoadTemplate\Logic;

use Game\Constant\ConstTemplate\TemplateSeasonStore;
use Game\Constant\TemplateDefine;
use Tool\LoadTemplate\Config;
use Tool\LoadTemplate\ILogic;
use Tool\LoadTemplate\Util;

class SeasonStoreLogic extends ILogic
{
    public function dealRow(&$row): bool
    {
        $row[TemplateSeasonStore::Id] = (int)$row[TemplateSeasonStore::Id];
        $row[TemplateSeasonStore::ItemId] = (int)$row[TemplateSeasonStore::ItemId];
        $row[TemplateSeasonStore::Num] = (int)$row[TemplateSeasonStore::Num];
        $row[TemplateSeasonStore::Term] = (int)$row[TemplateSeasonStore::Term];
        $row[TemplateSeasonStore::MaxNum] = (int)$row[TemplateSeasonStore::MaxNum];
        $row[TemplateSeasonStore::ConvertedType] = (int)$row[TemplateSeasonStore::ConvertedType];
        $row[TemplateSeasonStore::Price] = (int)$row[TemplateSeasonStore::Price];
        //赛季
        $row[TemplateSeasonStore::SeasonId] = Util::getFormatArrayToSemicolon($row[TemplateSeasonStore::SeasonId]);
        return true;
    }

    public function getTidyList(): array
    {
        return array(
            Config::TIDY_DEFINE[TemplateDefine::TYPE_SHOP_SEASON]
        );
    }
}
