<?php

namespace Tool\LoadTemplate\Logic;

use Game\Constant\ConstTemplate\TemplateCar;
use Game\Constant\ConstTemplate\TemplateRefit;
use Tool\LoadTemplate\ILogic;
use Tool\LoadTemplate\Util;

class RefitLogic extends ILogic
{
    public function dealKey($key, $val, &$title): bool
    {
        $title [$key] = $val;
        return true;
    }

    /**
     * @param $row
     * @return bool
     * 处理数据 对UseId和TimeLimit字段检查
     */
    public function dealRow(&$row): bool
    {
        $row[TemplateRefit::Skin] = Util::getFormatArrayToSemicolon($row[TemplateRefit::Skin]);
        $row[TemplateRefit::CarPaint] = Util::getFormatArrayToSemicolon($row[TemplateRefit::CarPaint]);
        $row[TemplateRefit::Empennage] = Util::getFormatArrayToSemicolon($row[TemplateRefit::Empennage]);
        $row[TemplateRefit::Hood] = Util::getFormatArrayToSemicolon($row[TemplateRefit::Hood]);
        $row[TemplateRefit::StripOfLights] = Util::getFormatArrayToSemicolon($row[TemplateRefit::StripOfLights]);
        $row[TemplateRefit::HangOrnament] = Util::getFormatArrayToSemicolon($row[TemplateRefit::HangOrnament]);
        $row[TemplateRefit::Wheel] = Util::getFormatArrayToSemicolon($row[TemplateRefit::Wheel]);
        $row[TemplateRefit::Hub] = Util::getFormatArrayToSemicolon($row[TemplateRefit::Hub]);
        $row[TemplateRefit::CarStickers] = Util::getFormatArrayToSemicolon($row[TemplateRefit::CarStickers]);
        $row[TemplateRefit::Plate] = Util::getFormatArrayToSemicolon($row[TemplateRefit::Plate]);

        return true;
    }

    public function dealFile(&$file): bool
    {
        return true;
    }

    public function getTidyList(): array
    {
        return array();
    }
}