<?php

namespace Tool\LoadTemplate\Logic;

use Game\Constant\ConstTemplate\TemplateRankingTest;
use Tool\LoadTemplate\ILogic;

class RankingTestLogic extends ILogic
{
    //玩家人数
    private array $player1Arr = array();
    private array $player2Arr = array();
    private array $player3Arr = array();

    public function dealRow(&$row): bool
    {
        $row[TemplateRankingTest::RoomPlayerNum] = (int)$row[TemplateRankingTest::RoomPlayerNum];
        $row[TemplateRankingTest::Level] = (int)$row[TemplateRankingTest::Level];
        $row[TemplateRankingTest::Score] = (int)$row[TemplateRankingTest::Score];
        $row[TemplateRankingTest::Position1PlayerId] = (int)$row[TemplateRankingTest::Position1PlayerId];
        $row[TemplateRankingTest::Position1Ratio] = (int)$row[TemplateRankingTest::Position1Ratio];
        $row[TemplateRankingTest::Position2PlayerId] = (int)$row[TemplateRankingTest::Position2PlayerId];
        $row[TemplateRankingTest::Position2Ratio] = (int)$row[TemplateRankingTest::Position2Ratio];
        $row[TemplateRankingTest::Position3PlayerId] = (int)$row[TemplateRankingTest::Position3PlayerId];
        $row[TemplateRankingTest::Position3Ratio] = (int)$row[TemplateRankingTest::Position3Ratio];
        if ($row[TemplateRankingTest::RoomPlayerNum] == 1) {
            $this->player1Arr[$row[TemplateRankingTest::Id]] = $row;
        } elseif ($row[TemplateRankingTest::RoomPlayerNum] == 2) {
            $this->player2Arr[$row[TemplateRankingTest::Id]] = $row;
        } else {
            $this->player3Arr[$row[TemplateRankingTest::Id]] = $row;
        }

        return true;
    }

    public function dealFile(&$file): bool
    {
        $file = array(
            1 => $this->player1Arr,
            2 => $this->player2Arr,
            3 => $this->player3Arr,
        );
        return true;
    }
}
