<?php

namespace Tool\LoadTemplate\Logic;

use Game\Constant\ConstTemplate\TemplateRankStraightWin;
use Tool\LoadTemplate\ILogic;

class RankStraightWinLogic extends ILogic
{
    private array $zero = array();
    private array $negative = array();  //连败场次
    private array $positive = array();  //连胜场次

    public function dealRow(&$row): bool
    {
        $row[TemplateRankStraightWin::WinNum] = (int)$row[TemplateRankStraightWin::WinNum];
        $row[TemplateRankStraightWin::Num] = (int)$row[TemplateRankStraightWin::Num];
        $row[TemplateRankStraightWin::Weight] = (int)$row[TemplateRankStraightWin::Weight];
        if ($row[TemplateRankStraightWin::WinNum] == 0) {
            $this->zero = $row;
        } elseif ($row[TemplateRankStraightWin::WinNum] > 0) {
            $this->positive[$row[TemplateRankStraightWin::WinNum]] = $row;
        } else {
            $this->negative[$row[TemplateRankStraightWin::WinNum]] = $row;
        }
        return true;
    }

    public function dealFile(&$file): bool
    {
        arsort($this->negative);
        $arr = array(
            TemplateRankStraightWin::ID_ZERO => $this->zero,
            TemplateRankStraightWin::ID_NEGATIVE => $this->negative,
            TemplateRankStraightWin::ID_POSITIVE => $this->positive,
        );
        $file = $arr;
        return true;
    }
}
