<?php

/**
 * 赛车熟练度
 */

namespace Tool\LoadTemplate\Logic;

use Game\Constant\ConstTemplate\TemplateProficiency;
use Tool\LoadTemplate\ILogic;
use Tool\LoadTemplate\Util;

class ProficiencyLogic extends ILogic
{
    private array $carProficiency = array();

    /**
     * @param $row
     * @return bool
     * 需要字段转为int
     */
    public function dealRow(&$row): bool
    {
        $row[TemplateProficiency::Level] = (int)$row[TemplateProficiency::Level];
        $row[TemplateProficiency::CarId] = (int)$row[TemplateProficiency::CarId];
        $row[TemplateProficiency::Exp] = (int)$row[TemplateProficiency::Exp];
        $row[TemplateProficiency::Reward] = Util::getFormatArray($row[TemplateProficiency::Reward]);
        $this->carProficiency[$row[TemplateProficiency::CarId]][$row[TemplateProficiency::Level]] = $row;
        return true;
    }

    public function dealFile(&$file): bool
    {
        $file = $this->carProficiency;
        return true;
    }
}
