<?php

namespace Tool\LoadTemplate\Logic;

use Game\Constant\ConstTemplate\TemplatePlayerLevel;
use Game\Constant\TemplateDefine;
use Tool\LoadTemplate\Config;
use Tool\LoadTemplate\ILogic;
use Tool\LoadTemplate\Util;

class PlayerLevelLogic  extends ILogic
{
    public function dealRow(&$row): bool
    {
        $row[TemplatePlayerLevel::Level] = (int)$row[TemplatePlayerLevel::Level];
        $row[TemplatePlayerLevel::Exp] = (int)$row[TemplatePlayerLevel::Exp];
        if ($row[TemplatePlayerLevel::FunctionID] == "0") {
            $row[TemplatePlayerLevel::FunctionID] = array();
        } else {
            $row[TemplatePlayerLevel::FunctionID] = Util::getFormatArray3($row[TemplatePlayerLevel::FunctionID]);
        }
        $row[TemplatePlayerLevel::Reward] = Util::getFormatArray($row[TemplatePlayerLevel::Reward]);
        return true;
    }

    public function getTidyList(): array
    {
        return array(
            Config::TIDY_DEFINE[TemplateDefine::TYPE_PLAYER_LEVEL]
        );
    }
}
