<?php

/**
 * PVP比赛模式
 */

namespace Tool\LoadTemplate\Logic;

use Game\Constant\ConstTemplate\TemplatePVPMatch;
use Tool\LoadTemplate\ILogic;

class PVPMatchLogic extends ILogic
{
    public function dealRow(&$row): bool
    {
        $row[TemplatePVPMatch::Id] = (int)$row[TemplatePVPMatch::Id];
        $row[TemplatePVPMatch::MaxPlayer] = (int)$row[TemplatePVPMatch::MaxPlayer];
        if (!in_array($row[TemplatePVPMatch::Id], TemplatePVPMatch::RANK_ID)) {
            $tmp = explode("-", $row[TemplatePVPMatch::TimeString]);
            if (count($tmp) != 2) {
                return false;
            }
            $row[TemplatePVPMatch::MaxTime] = (int)$tmp[1];
        }
        return true;
    }
}
