<?php

/**
 * 赛季时间
 */

namespace Tool\LoadTemplate\Logic;

use Game\Constant\ConstTemplate\TemplateMatchTime;
use Tool\LoadTemplate\ILogic;
use Tool\LoadTemplate\Util;

class MatchTimeLogic extends ILogic
{
    public function dealKey($key, $val, &$title): bool
    {
        $title [$key] = $val;
        return true;
    }

    /**
     * @param $row
     * @return bool
     */
    public function dealRow(&$row): bool
    {
        if ($row[TemplateMatchTime::StartTime] == "None" || $row[TemplateMatchTime::EndTime] == "None" ) {
            return true;
        }
        $row[TemplateMatchTime::Id] = intval($row[TemplateMatchTime::Id]);
        $sTime = $eTime = 0;
        if (false == Util::StringToTime($row[TemplateMatchTime::StartTime], $sTime)) {
            return false;
        }
        if (false == Util::StringToTime($row[TemplateMatchTime::EndTime], $eTime)) {
            return false;
        }
        $row[TemplateMatchTime::StartTime] = $sTime;
        $row[TemplateMatchTime::EndTime] = $eTime;

        return true;
    }

    public function dealFile(&$file): bool
    {
        return true;
    }

    public function getTidyList(): array
    {
        return array();
    }
}
